/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.registry;

import java.util.function.BiFunction;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CDDShapes {
    public static final VoxelShaper STEPPED_LEVER = CDDShapes.shape(4.0, 0.0, 0.0, 12.0, 5.0, 16.0).forHorizontalAxis();
    public static final VoxelShaper STEPPED_LEVER_CEILING = CDDShapes.shape(4.0, 11.0, 0.0, 15.0, 16.0, 16.0).forHorizontalAxis();
    public static final VoxelShaper STEPPED_LEVER_WALL = CDDShapes.shape(4.0, 0.0, 0.0, 12.0, 16.0, 5.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper BREAKER_SWITCH = CDDShapes.shape(4.0, 0.0, 2.0, 12.0, 3.0, 14.0).forHorizontalAxis();
    public static final VoxelShaper BREAKER_SWITCH_CEILING = CDDShapes.shape(4.0, 13.0, 2.0, 15.0, 16.0, 14.0).forHorizontalAxis();
    public static final VoxelShaper BREAKER_SWITCH_WALL = CDDShapes.shape(4.0, 2.0, 0.0, 12.0, 14.0, 3.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper DIAGONAL_METAL_SUPPORT = CDDShapes.shape(3.0, 0.0, 11.0, 13.0, 10.0, 16.0).add(0.0, 12.0, 0.0, 16.0, 16.0, 16.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper METAL_SUPPORT = CDDShapes.shape(4.0, 13.0, 0.0, 12.0, 16.0, 16.0).add(4.0, 0.0, 4.0, 12.0, 13.0, 12.0).forHorizontalAxis();
    public static final VoxelShape CATWALK_DOWN = CDDShapes.shape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0).build();
    public static final VoxelShape CATWALK = CDDShapes.shape(0.0, 14.0, 0.0, 16.0, 16.0, 16.0).build();
    public static final VoxelShape WOODEN_SUPPORT = CDDShapes.shape(4.0, 0.0, 4.0, 12.0, 16.0, 12.0).build();
    public static final VoxelShape EMPTY = CDDShapes.shape(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).build();

    private static Builder shape(VoxelShape shape) {
        return new Builder(shape);
    }

    private static Builder shape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return CDDShapes.shape(CDDShapes.cuboid(x1, y1, z1, x2, y2, z2));
    }

    private static VoxelShape cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static class Builder {
        private VoxelShape shape;

        public Builder(VoxelShape shape) {
            this.shape = shape;
        }

        public Builder add(VoxelShape shape) {
            this.shape = Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)shape);
            return this;
        }

        public Builder add(double x1, double y1, double z1, double x2, double y2, double z2) {
            return this.add(CDDShapes.cuboid(x1, y1, z1, x2, y2, z2));
        }

        public Builder erase(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)CDDShapes.cuboid(x1, y1, z1, x2, y2, z2), (BooleanOp)BooleanOp.f_82685_);
            return this;
        }

        public VoxelShape build() {
            return this.shape;
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction, VoxelShaper> factory, Direction direction) {
            return factory.apply(this.shape, direction);
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction.Axis, VoxelShaper> factory, Direction.Axis axis) {
            return factory.apply(this.shape, axis);
        }

        public VoxelShaper forDirectional(Direction direction) {
            return this.build(VoxelShaper::forDirectional, direction);
        }

        public VoxelShaper forAxis() {
            return this.build(VoxelShaper::forAxis, Direction.Axis.Y);
        }

        public VoxelShaper forHorizontalAxis() {
            return this.build(VoxelShaper::forHorizontalAxis, Direction.Axis.Z);
        }

        public VoxelShaper forHorizontal(Direction direction) {
            return this.build(VoxelShaper::forHorizontal, direction);
        }

        public VoxelShaper forDirectional() {
            return this.forDirectional(Direction.UP);
        }
    }
}

